<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="_token" content="YemuWyUgmrxZtSdMxw4UC1q7596nay9qAJBgVm9s">
    <title>Manu's Kitchen</title>
    <style media="screen">
    *{
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        a {
            color: #0072EF;
            text-decoration: none;
        }
        body {
            background: white;
        }
        .container {
            max-width: 940px;
            margin: 0 auto;
            padding: 0 5%;
            padding-top: 20px;
            padding-bottom: 20px;
        }
        .sub-nav {
            display: flex;
            flex-direction: column;
            align-items: baseline;
            flex-direction: row;
            padding-bottom: 15px;
        }
        .breadcrumbs {
            margin: 0;
            padding: 0;
        }
        .breadcrumbs li {
            color: #666;
            display: inline;
            max-width: 450px;
            overflow: hidden;
            text-overflow: ellipsis;
            font-weight: 500;
            font-size: 12px;
        }
        .breadcrumbs li + li::before {
            content: "/";
            margin: 0 2px;
        }
        .content_wrapper {
            background: #fff;
            border-radius: 4px;
            padding: 20px;
            height:auto;
        }
        .content_wrapper h1{
            font-size: 20px;
            font-weight: bold;
            margin: 0 0 .67em 0;
        }
        .form {
            max-width: 650px;
        }
        .form_input, .nesty-panel {
            box-sizing: border-box;
        }
        .form_input {
            background-color: #fff;
            border: 1px solid #ececec;
            border-radius: 1px;
            box-shadow: inset 0 1px #e3e3e3;
            color: #333;
            cursor: pointer;
            display: inline-block;
            height: 30px;
            line-height: 30px;
            margin: 0;
            max-width: 250px;
            min-width: 150px;
            overflow: hidden;
            padding: 0 20px 0 5px;
            position: relative;
            text-overflow: ellipsis;
            z-index: 1;
            width: 100%;
            white-space: nowrap;
        }
        .form_input {
            border: 1px solid #ddd;
            border-radius: 2px;
            box-shadow: none;
            padding: 0 15px 0 10px;
        }
        .form-field .form_input {
            border-radius: 4px;
            height: 40px;
            line-height: 40px;
            outline: none;
            vertical-align: middle;
            max-width: 100%;
        }
        .form-field ~ .form-field {
            margin-top: 25px;
        }
        .form-field label {
            display: block;
            font-size: 13px;
            margin-bottom: 5px;
        }
        input {
            font-weight: 300;
            max-width: 100%;
            box-sizing: border-box;
            outline: none;
            transition: border .12s ease-in-out;
        }
        .form-field input {
            border: 1px solid #ddd;
            border-radius: 4px;
            padding: 10px;
            width: 100%;
        }
        .form-field input[type="text"] {
            border: 1px solid #ddd;
            border-radius: 4px;
        }
        .form-field input[type="text"]:focus {
            border: 1px solid rgba(11, 0, 239, 1);
        }
        textarea {
            border: 1px solid #ddd;
            border-radius: 2px;
            resize: vertical;
            width: 100%;
            outline: none;
            padding: 10px;
        }
        .form-field textarea {
            vertical-align: middle;
            max-width: 100%;
        }
        .request-form textarea {
            min-height: 120px;
        }
        .form-field p {
            color: #666;
            font-size: 12px;
            margin: 5px 0;
        }
        .upload-dropzone input[type="file"] {
            opacity: 0;
            position: absolute;
            top: 0;
            right: 0;
            cursor: pointer;
            height: 100%;
            width: 100%;
        }
        .upload-dropzone {
            border: 1px solid #ddd;
            font-size: 12px;
            overflow: hidden;
            position: relative;
            text-align: center;
        }
        .upload-dropzone span {
            color: #666;
            display: inline-block;
            line-height: 24px;
            padding: 10px;
        }
        .upload-dropzone a {
            text-decoration: none;
            font-size: 13px;
        }
        .submit_from{
            margin-top: 40px;
            padding-top: 30px;
        }
        .button-large, input[type="submit"] {
            background-color: #00b137;
            border: 0;
            border-radius: 4px;
            color: #FFFFFF;
            font-size: 16px;
            line-height: 2.72;
            min-width: 140px;
            padding: 0 1.9286em;
            width: auto;
            margin-left: 16px;
            height: 40px;
            font-weight: 700;
            text-transform: uppercase;
        }
        .request_ticket_form_id_hint {
            font-size: 14px !important;
            color: #797979 !important;
            position: relative;
            margin-top: 26px !important;
            margin: 5px 0;
        }
        .request_ticket_form_id_hint::before {
            content: "";
            background: url(//theme.zdassets.com/theme_assets/2478323/4f1670974929e0c9fc68c4b81246cb61b32422bf.svg);
            height: 20px;
            width: 20px;
            top: 0;
            left: 0;
            position: absolute;
        }
        .request_ticket_form_id_hint span {
            padding-left: 30px;
            display: block;
        }
        .form-field.required > label::after {
            content: "*";
            color:red;
            margin-left: 2px;
        }
        .pan-card-img {
            vertical-align: middle;
            display: flex;
            margin: 0 auto;
        }
        .request-form textarea {
            min-height: 120px;
        }
    </style>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.0/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL" crossorigin="anonymous"></script>
</head>
<body>
    <section>
        <div class="container">
            <div class="content_wrapper">
                <h1 id = "form-header" style="color:rgba(11, 0, 239, 1); font-weight:bold;">
                    Permanent Delete Manu's Kitchen Account
                </h1>

                <?php if(session()->has('message')): ?>
                    <div class="alert alert-success" role="alert" bis_skin_checked="1">
                        <?php echo e(session()->get('message')); ?>

                    </div>
                <?php endif; ?>

                <div class="form">
                    <div id="myForm">
                        <form method="post" action="<?php echo e(route('app_account_delete')); ?>" id="demo-form2" data-parsley-validate class="form-horizontal form-label-left" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="form-field select optional request_ticket_form_id required">
                                <select name="issue_type" id="issue_type" class="form_input"
                                    aria-label="Choose the appropriate option from the drop-down Menu to see a customized form to help you serve better."
                                    autofocus="autofocus">
                                    <option data-url="#" value=""> Select Reason </option>
                                    <option data-url="#"  value="Lost My Mobile"> Lost My Mobile </option>
                                    <option data-url="#"  value="Due Policy Issue"> Due Policy Issue </option>
                                    <option data-url="#"  value="Other"> Other </option>
                                </select>
                            </div>
                            <!-- start deposit -->
                            <div class="form" id="deposit">
                                <div class="form-field required">
                                    <label style="margin-top:4%;" for="email">Your email address</label>
                                    <input type="text" name="email" id="email" aria-required="true">
                                    
                                </div>
                                <div class="form-field required">
                                    <label id="textarea" for="description">Description</label>
                                    <textarea name="description" id="" minlength="10" maxlength="200"></textarea>
                                    <p id="request_description_hint">Please enter the details of your request in less than
                                        200 characters. A member of our support staff will respond as soon as possible.</p>
                                    
                                </div>
                                <div class="form-field request-attachment-div upload_attachment">
                                    <label for="request-attachments">
                                        Attachments
                                    </label>
                                    <div id="upload-dropzone" class="upload-dropzone">
                                        <input type="file" multiple="true" name="file_upload" id="request-attachments" data-fileupload="true"
                                            data-dropzone="upload-dropzone" data-error="upload-error"
                                            data-create-url="/hc/en-us/request_uploads" data-name="request[file_upload][]"
                                            data-pool="request-file_upload-pool" data-delete-confirm-msg=""
                                            aria-describedby="upload-error">
                                        <span>
                                            <a>Add file</a> or drop files here
                                        </span>
                                    </div>
                                </div>
                                <p class="request_ticket_form_id_hint"><span>Check for an acknowledgement sent to your email
                                        ID after raising the request.</span></p>
                                <div class="submit_from" id="submit">
                                    <input type="submit" name="commit"  id="submitBtn" value="Submit">
                                </div>
                            </div>
                            <!-- End deposit -->
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <script type="text/javascript">
        $(document).ready(function(){
            $("#deposit").hide();
            $("#issue_type").on("change",function() {
                if ($(this).val() === "Lost My Mobile") {
                    $("#deposit").show(); 
                    $("#submit").show(); 
                }else if ($(this).val() === "Due Policy Issue") {
                    $("#deposit").show(); 
                    $("#submit").show(); 
                }else if ($(this).val() === "Other") {
                    $("#deposit").show(); 
                    $("#submit").show(); 
                }else if ($(this).val() === "") {
                    $("#deposit").hide();
                    $("#submit").hide(); 
                }
            });
        });
    </script>
</body>
</html>
<?php /**PATH /var/www/rglabs/food_delivery/resources/views/suspended_account.blade.php ENDPATH**/ ?>