

<?php $__env->startSection('title', translate('Location Settings')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-end">
                <div class="col-sm mb-2 mb-sm-0">
                    <h1 class="page-header-title"><?php echo e(translate('Location Settings')); ?></h1>
                </div>

                <div class="col-sm-auto">
                    <a class="btn btn-primary" href="<?php echo e(route('admin.dashboard')); ?>">
                        <i class="tio-home mr-1"></i> <?php echo e(translate('Dashboard')); ?>

                    </a>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">

                <div id="locationDiv" class="card mb-3 mb-lg-5">
                    <div class="card-header">
                        <h4 class="card-title"><i class="tio-poi"></i> <?php echo e(translate('Location Settings')); ?></h4>
                    </div>

                    <div class="card-body">
                        <form id="distanceLocationForm" action="<?php echo e(route('admin.settings-location')); ?>" method="post">
                            <?php echo csrf_field(); ?>

                            <div class="row form-group">
                                <label for="distance" class="col-sm-3 col-form-label input-label"><?php echo e(translate('Distance (km)')); ?></label>
                                <div class="col-sm-9">
                                    <input type="number" name="distance" class="form-control"
                                        id="distance" placeholder="<?php echo e(translate('Enter distance in km')); ?>"
                                        value="<?php echo e(auth('admin')->user()->distance ?? ''); ?>" required>
                                </div>
                            </div>

                            <div class="row form-group">
                                <label for="latitude" class="col-sm-3 col-form-label input-label"><?php echo e(translate('Latitude')); ?></label>
                                <div class="col-sm-9">
                                    <input type="text" name="latitude" class="form-control" id="latitude"
                                        value="<?php echo e(auth('admin')->user()->latitude ?? ''); ?>" readonly required>
                                </div>
                            </div>

                            <div class="row form-group">
                                <label for="longitude" class="col-sm-3 col-form-label input-label"><?php echo e(translate('Longitude')); ?></label>
                                <div class="col-sm-9">
                                    <input type="text" name="longitude" class="form-control" id="longitude"
                                        value="<?php echo e(auth('admin')->user()->longitude ?? ''); ?>" readonly required>
                                </div>
                            </div>

                            <div class="row form-group">
                                <label class="col-sm-3 col-form-label input-label"><?php echo e(translate('Select Location')); ?></label>
                                <div class="col-sm-9">
                                    <div id="map" style="height: 300px; width: 100%; border-radius: 8px; border: 1px solid #ddd;"></div>
                                </div>
                            </div>

                            <div class="d-flex justify-content-end">
                                <button type="submit" id="saveLocationButton" class="btn btn-primary"><?php echo e(translate('Save changes')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>

                <div id="stickyBlockEndPoint"></div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script src="<?php echo e(asset('public/assets/admin/js/settings.js')); ?>"></script>

    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyB9nhGUMnEJcqsJTr0YKrmHV9D5ZKhpdKs"></script>
    <script>
        let map, marker;

        function initMap(lat, lng) {
            const defaultLocation = { lat: parseFloat(lat), lng: parseFloat(lng) };
            map = new google.maps.Map(document.getElementById("map"), {
                center: defaultLocation,
                zoom: 12,
            });

            marker = new google.maps.Marker({
                position: defaultLocation,
                map: map,
                draggable: true,
            });

            // Update inputs on marker drag
            google.maps.event.addListener(marker, 'dragend', function (event) {
                document.getElementById("latitude").value = event.latLng.lat();
                document.getElementById("longitude").value = event.latLng.lng();
            });
        }

        // Get lat-long from IP (free API)
        fetch("https://ipapi.co/json/")
            .then(res => res.json())
            .then(data => {
                let lat = data.latitude;
                let lng = data.longitude;

                // If already stored in DB, use that instead
                let dbLat = "<?php echo e(auth('admin')->user()->latitude ?? ''); ?>";
                let dbLng = "<?php echo e(auth('admin')->user()->longitude ?? ''); ?>";

                if (dbLat && dbLng) {
                    lat = dbLat;
                    lng = dbLng;
                }

                document.getElementById("latitude").value = lat;
                document.getElementById("longitude").value = lng;

                initMap(lat, lng);
            })
            .catch(() => {
                // fallback to a default location if IP fetch fails
                initMap(28.6139, 77.2090); // Delhi
            });
    </script>

<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/rglabs/food_delivery/resources/views/admin-views/location.blade.php ENDPATH**/ ?>